/*! For license information please see editor-styles-repository.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-styles-repository/src/errors.ts":function(e,r,t){t.r(r),t.d(r,{ActiveDocumentMustExistError:function(){return i},InvalidElementsStyleProviderMetaError:function(){return o}});var s=t("@elementor/utils");const o=(0,s.createError)({code:"invalid_elements_style_provider_meta",message:"Invalid elements style provider meta."}),i=(0,s.createError)({code:"active_document_must_exist",message:"Active document must exist."})},"./packages/packages/core/editor-styles-repository/src/hooks/use-get-styles-repository-create-action.ts":function(e,r,t){t.r(r),t.d(r,{useGetStylesRepositoryCreateAction:function(){return useGetStylesRepositoryCreateAction}});var s=t("react"),o=t("./packages/packages/core/editor-styles-repository/src/styles-repository.ts"),i=t("./packages/packages/core/editor-styles-repository/src/hooks/use-user-styles-capability.ts");function useGetStylesRepositoryCreateAction(){const{userCan:e}=(0,i.useUserStylesCapability)();return(0,s.useMemo)(()=>{const r=o.stylesRepository.getProviders().map(r=>r.actions.create&&e(r.getKey()).create?[r,r.actions.create]:null).filter(Boolean);if(1===r.length)return r[0];if(0===r.length)return null;throw new Error("Multiple providers with create action found in styles repository.")},[])}},"./packages/packages/core/editor-styles-repository/src/hooks/use-providers.ts":function(e,r,t){t.r(r),t.d(r,{useProviders:function(){return useProviders}});var s=t("react"),o=t("./packages/packages/core/editor-styles-repository/src/styles-repository.ts");function useProviders(){const[,e]=(0,s.useReducer)(e=>!e,!1);return(0,s.useEffect)(()=>o.stylesRepository.subscribe(e),[]),o.stylesRepository.getProviders()}},"./packages/packages/core/editor-styles-repository/src/hooks/use-user-styles-capability.ts":function(e,r,t){t.r(r),t.d(r,{useUserStylesCapability:function(){return useUserStylesCapability}});var s=t("@elementor/editor-current-user"),o=t("./packages/packages/core/editor-styles-repository/src/styles-repository.ts");const i={create:!0,delete:!0,update:!0,updateProps:!0},useUserStylesCapability=()=>{const{capabilities:e}=(0,s.useCurrentUserCapabilities)();return{userCan:r=>{const t=o.stylesRepository.getProviderByKey(r);return t?.capabilities?Object.entries(t.capabilities).reduce((r,[t,s])=>({...r,[t]:e?.includes(s)??!0}),i):i}}}},"./packages/packages/core/editor-styles-repository/src/init.ts":function(e,r,t){t.r(r),t.d(r,{init:function(){return init}});var s=t("./packages/packages/core/editor-styles-repository/src/providers/document-elements-styles-provider.ts"),o=t("./packages/packages/core/editor-styles-repository/src/providers/element-base-styles-provider.ts"),i=t("./packages/packages/core/editor-styles-repository/src/styles-repository.ts");function init(){i.stylesRepository.register(s.documentElementsStylesProvider),i.stylesRepository.register(o.elementBaseStylesProvider)}},"./packages/packages/core/editor-styles-repository/src/providers/document-elements-styles-provider.ts":function(e,r,t){t.r(r),t.d(r,{ELEMENTS_STYLES_PROVIDER_KEY_PREFIX:function(){return n},ELEMENTS_STYLES_RESERVED_LABEL:function(){return c},documentElementsStylesProvider:function(){return l}});var s=t("@elementor/editor-elements"),o=t("@elementor/editor-v1-adapters"),i=t("./packages/packages/core/editor-styles-repository/src/errors.ts"),a=t("./packages/packages/core/editor-styles-repository/src/utils/create-styles-provider.ts");const n="document-elements-",c="local",l=(0,a.createStylesProvider)({key:()=>{const e=(0,s.getCurrentDocumentId)();if(!e)throw new i.ActiveDocumentMustExistError;return`${n}${e}`},priority:50,subscribe:e=>(0,o.__privateListenTo)(s.styleRerenderEvents,e),actions:{all:(e={})=>{let r=(0,s.getElements)();return isValidElementsMeta(e)&&(r=r.filter(r=>r.id===e.elementId)),r.flatMap(e=>Object.values(e.model.get("styles")??{}))},get:(e,r={})=>{if(!isValidElementsMeta(r))throw new i.InvalidElementsStyleProviderMetaError({context:{meta:r}});return((0,s.getElementStyles)(r.elementId)??{})[e]??null},updateProps:(e,r={})=>{if(!isValidElementsMeta(r))throw new i.InvalidElementsStyleProviderMetaError({context:{meta:r}});(0,s.updateElementStyle)({elementId:r.elementId,styleId:e.id,meta:e.meta,props:e.props})}}});function isValidElementsMeta(e){return"elementId"in e&&"string"==typeof e.elementId&&!!e.elementId}},"./packages/packages/core/editor-styles-repository/src/providers/element-base-styles-provider.ts":function(e,r,t){t.r(r),t.d(r,{ELEMENTS_BASE_STYLES_PROVIDER_KEY:function(){return i},elementBaseStylesProvider:function(){return a}});var s=t("@elementor/editor-elements"),o=t("./packages/packages/core/editor-styles-repository/src/utils/create-styles-provider.ts");const i="element-base-styles",a=(0,o.createStylesProvider)({key:i,actions:{all(){const e=(0,s.getWidgetsCache)();return Object.values(e??{}).flatMap(e=>Object.values(e.base_styles??{}))},get(e){return this.all().find(r=>r.id===e)??null}}})},"./packages/packages/core/editor-styles-repository/src/styles-repository.ts":function(e,r,t){t.r(r),t.d(r,{stylesRepository:function(){return s}});const s=(0,t("./packages/packages/core/editor-styles-repository/src/utils/create-styles-repository.ts").createStylesRepository)()},"./packages/packages/core/editor-styles-repository/src/types.ts":function(e,r,t){t.r(r)},"./packages/packages/core/editor-styles-repository/src/utils/create-styles-provider.ts":function(e,r,t){t.r(r),t.d(r,{createStylesProvider:function(){return createStylesProvider}});const s=1e4,o=10;function createStylesProvider({key:e,priority:r=o,limit:t=s,subscribe:i=()=>()=>{},labels:a,actions:n,capabilities:c}){return{getKey:"string"==typeof e?()=>e:e,priority:r,limit:t,capabilities:c,subscribe:i,labels:{singular:a?.singular??null,plural:a?.plural??null},actions:{all:n.all,get:n.get,resolveCssName:n.resolveCssName??(e=>e),create:n.create,delete:n.delete,update:n.update,updateProps:n.updateProps}}}},"./packages/packages/core/editor-styles-repository/src/utils/create-styles-repository.ts":function(e,r,t){t.r(r),t.d(r,{createStylesRepository:function(){return createStylesRepository}});const createStylesRepository=()=>{const e=[],getProviders=()=>e.slice(0).sort((e,r)=>e.priority>r.priority?-1:1);return{all:(e={})=>getProviders().flatMap(r=>r.actions.all(e)),register:r=>{e.push(r)},subscribe:r=>{const t=e.map(e=>e.subscribe(r));return()=>{t.forEach(e=>e())}},getProviders:getProviders,getProviderByKey:r=>e.find(e=>e.getKey()===r)}}},"./packages/packages/core/editor-styles-repository/src/utils/is-elements-styles-provider.ts":function(e,r,t){t.r(r),t.d(r,{isElementsStylesProvider:function(){return isElementsStylesProvider}});var s=t("./packages/packages/core/editor-styles-repository/src/providers/document-elements-styles-provider.ts");function isElementsStylesProvider(e){return new RegExp(`^${s.ELEMENTS_STYLES_PROVIDER_KEY_PREFIX}\\d+$`).test(e)}},"./packages/packages/core/editor-styles-repository/src/utils/validate-style-label.ts":function(e,r,t){t.r(r),t.d(r,{validateStyleLabel:function(){return validateStyleLabel}});var s=t("@elementor/schema"),o=t("@wordpress/i18n"),i=t("./packages/packages/core/editor-styles-repository/src/providers/document-elements-styles-provider.ts"),a=t("./packages/packages/core/editor-styles-repository/src/styles-repository.ts");const n=["container"],c=s.z.string().max(50,(0,o.__)("Class name is too long. Please keep it under 50 characters.","elementor")).regex(/^(|[^0-9].*)$/,(0,o.__)("Class names must start with a letter.","elementor")).regex(/^\S*$/,(0,o.__)("Class names can’t contain spaces.","elementor")).regex(/^(|[a-zA-Z0-9_-]+)$/,(0,o.__)("Class names can only use letters, numbers, dashes (-), and underscores (_).","elementor")).regex(/^(?!--).*/,(0,o.__)("Double hyphens are reserved for custom properties.","elementor")).regex(/^(?!-[0-9])/,(0,o.__)("Class names can’t start with a hyphen followed by a number.","elementor")).refine(e=>!n.includes(e),{message:(0,o.__)("This name is reserved and can’t be used. Try something more specific.","elementor")});function validateStyleLabel(e,r){const t=new Set([i.ELEMENTS_STYLES_RESERVED_LABEL,...a.stylesRepository.all().map(e=>e.label.toLowerCase())]),s=["create","rename"].includes(r),n=c.refine(e=>!(s&&e.length<2),{message:(0,o.__)("Class name is too short. Use at least 2 characters.","elementor")}).refine(e=>!(s&&t.has(e)),{message:(0,o.__)("This class name already exists. Please choose a unique name.","elementor")}).safeParse(e.toLowerCase());return n.success?{isValid:!0,errorMessage:null}:{isValid:!1,errorMessage:n.error.format()._errors[0]}}},"@elementor/editor-current-user":function(e){e.exports=window.elementorV2.editorCurrentUser},"@elementor/editor-elements":function(e){e.exports=window.elementorV2.editorElements},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},r={};function __webpack_require__(t){var s=r[t];if(void 0!==s)return s.exports;var o=r[t]={exports:{}};return e[t](o,o.exports,__webpack_require__),o.exports}__webpack_require__.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(r,{a:r}),r},__webpack_require__.d=function(e,r){for(var t in r)__webpack_require__.o(r,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:r[t]})},__webpack_require__.o=function(e,r){return Object.prototype.hasOwnProperty.call(e,r)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var t={};!function(){__webpack_require__.r(t),__webpack_require__.d(t,{ELEMENTS_BASE_STYLES_PROVIDER_KEY:function(){return c.ELEMENTS_BASE_STYLES_PROVIDER_KEY},ELEMENTS_STYLES_PROVIDER_KEY_PREFIX:function(){return l.ELEMENTS_STYLES_PROVIDER_KEY_PREFIX},ELEMENTS_STYLES_RESERVED_LABEL:function(){return l.ELEMENTS_STYLES_RESERVED_LABEL},createStylesProvider:function(){return a.createStylesProvider},init:function(){return p.init},isElementsStylesProvider:function(){return n.isElementsStylesProvider},stylesRepository:function(){return e.stylesRepository},useGetStylesRepositoryCreateAction:function(){return s.useGetStylesRepositoryCreateAction},useProviders:function(){return r.useProviders},useUserStylesCapability:function(){return o.useUserStylesCapability},validateStyleLabel:function(){return i.validateStyleLabel}});__webpack_require__("./packages/packages/core/editor-styles-repository/src/types.ts");var e=__webpack_require__("./packages/packages/core/editor-styles-repository/src/styles-repository.ts"),r=__webpack_require__("./packages/packages/core/editor-styles-repository/src/hooks/use-providers.ts"),s=__webpack_require__("./packages/packages/core/editor-styles-repository/src/hooks/use-get-styles-repository-create-action.ts"),o=__webpack_require__("./packages/packages/core/editor-styles-repository/src/hooks/use-user-styles-capability.ts"),i=__webpack_require__("./packages/packages/core/editor-styles-repository/src/utils/validate-style-label.ts"),a=__webpack_require__("./packages/packages/core/editor-styles-repository/src/utils/create-styles-provider.ts"),n=__webpack_require__("./packages/packages/core/editor-styles-repository/src/utils/is-elements-styles-provider.ts"),c=__webpack_require__("./packages/packages/core/editor-styles-repository/src/providers/element-base-styles-provider.ts"),l=__webpack_require__("./packages/packages/core/editor-styles-repository/src/providers/document-elements-styles-provider.ts"),p=__webpack_require__("./packages/packages/core/editor-styles-repository/src/init.ts")}(),(window.elementorV2=window.elementorV2||{}).editorStylesRepository=t}(),window.elementorV2.editorStylesRepository?.init?.();
//# sourceMappingURL=editor-styles-repository.js.map